//
//  MCInspectorControl.h
//  MCApplication
//
//  Created by aj on Wed Sep 26 2001.
//  Copyright (c) 2001 __CompanyName__. All rights reserved.
//

#import <Cocoa/Cocoa.h>

#import "MCWindowController.h"

@class MCSwitchView;
@interface MCInspectorControl : MCWindowController {

    NSMutableDictionary 	*inspectors;
    
    IBOutlet	MCSwitchView	*switchView;
    
    id				inspectedObject;
    
    BOOL			isLocked;
    BOOL			isAwake;
    BOOL			registeredForNotifications;
	BOOL			_didToggleLock;

}

// wake up from the recycle pool or when new (invoke by the inspector center)
- (void)awakeFromInspectorCenter;

// go to sleep when entering the recycle pool (invoked by the inspector center)
- (void)sleepIntoInspectorCenter;

// Returns the inspector instance for a given object, if it's not in the local cache, a new instance asked for from the inspector center -- also sets the inspected object on the switched inspector (switches the view as well)
- (id)switchToInspectorForObject:(id)anObject;

- (void)setInspectedObject:(id)anObject;
- (id)inspectedObject;

- (IBAction)toggleLock:(id)sender;

// send the message to the second switchView
- (IBAction)takeNestedSwitchViewValueFrom:(id)sender;


- (void)documentWillCloseNotification:(NSNotification *)notification;

@end
